// Generic IO functions
#include <xc.h>

#ifndef _SETTINGS_H    /* Guard against multiple inclusion */
#define _SETTINGS_H

typedef enum {
    UART_MODE_ASCII=1,
    UART_MODE_ASCII_EXT,
    UART_MODE_VT100    
}uartMode;

typedef enum {
    UART_LE_CRONLY=1,       //Note- this gives uartLE&1 => CR
    UART_LE_LFONLY,         //      and uartLE&2 => LF
    UART_LE_CRLF
}uartLE;

uartMode currentUartMode,newUartMode;
uartLE currentUartLE,newUartLE;
uint32_t currentBaudRate,newBaudRate;

void defaultSettings();                     //load sensible defaults
void saveSettings();                        
void loadSettings();
void doSetupMenu();                         //main menu setup routine
void printMenu();

#endif // _SETTINGS_H
